/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEAbstractClientPlayer;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.platform_specific.forge.networking.IPMessage;
import qouteall.imm_ptl.core.platform_specific.forge.networking.Teleport;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Vec2d;

@OnlyIn(value=Dist.CLIENT)
public class ClientTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Minecraft client = Minecraft.m_91087_();
    public static long tickTimeForTeleportation = 0L;
    private static long lastTeleportGameTime = 0L;
    private static long teleportTickTimeLimit = 0L;
    private static Vec3 lastPlayerEyePos = null;
    private static long lastRecordStableTickTime = 0L;
    private static float lastRecordStablePartialTicks = 0.0f;
    public static boolean isTeleportingTick = false;
    public static boolean isTeleportingFrame = false;
    public static boolean isTicking = false;
    private static final int teleportLimitPerFrame = 2;
    private static long teleportationCounter = 0L;

    public static void init() {
        IPGlobal.postClientTickSignal.connect(ClientTeleportationManager::tick);
        IPGlobal.clientCleanupSignal.connect(() -> {
            lastPlayerEyePos = null;
        });
    }

    private static void tick() {
        ++tickTimeForTeleportation;
        ClientTeleportationManager.changePlayerMotionIfCollidingWithPortal();
        isTeleportingTick = false;
    }

    public static void acceptSynchronizationDataFromServer(ResourceKey<Level> dimension, Vec3 pos, boolean forceAccept) {
        if (!forceAccept) {
            if (ClientTeleportationManager.isTeleportingFrequently()) {
                return;
            }
            if (ClientTeleportationManager.client.f_91074_.f_19797_ < 200) {
                return;
            }
        }
        if (ClientTeleportationManager.client.f_91074_.m_9236_().m_46472_() != dimension) {
            ClientTeleportationManager.forceTeleportPlayer(dimension, pos);
        }
    }

    public static void manageTeleportation(boolean isTicking_) {
        if (IPGlobal.disableTeleportation) {
            return;
        }
        isTicking = isTicking_;
        ++teleportationCounter;
        isTeleportingFrame = false;
        if (ClientTeleportationManager.client.f_91073_ == null || ClientTeleportationManager.client.f_91074_ == null) {
            lastPlayerEyePos = null;
            return;
        }
        if (ClientTeleportationManager.client.f_91074_.f_19854_ == 0.0 && ClientTeleportationManager.client.f_91074_.f_19855_ == 0.0 && ClientTeleportationManager.client.f_91074_.f_19856_ == 0.0) {
            return;
        }
        client.m_91307_().m_6180_("ip_teleport");
        ClientPortalAnimationManagement.foreachCustomAnimatedPortals(portal -> PortalExtension.forClusterPortals(portal, p -> p.animation.updateClientState((Portal)p, teleportationCounter)));
        float realPartialTicks = RenderStates.getPartialTick();
        TeleportationUtil.Teleportation lastTeleportation = null;
        if (lastPlayerEyePos != null) {
            TeleportationUtil.Teleportation teleportation;
            for (int i = 0; i < 2 && (teleportation = ClientTeleportationManager.tryTeleport(realPartialTicks)) != null; ++i) {
                lastTeleportation = teleportation;
                if (i == 0) continue;
                Helper.log("The client player made a combo-teleport");
            }
        }
        if (lastTeleportation != null && PortalExtension.get((Portal)lastTeleportation.portal()).adjustPositionAfterTeleport) {
            ClientTeleportationManager.adjustPlayerPosition(ClientTeleportationManager.client.f_91074_);
        }
        lastPlayerEyePos = ClientTeleportationManager.getPlayerEyePos(realPartialTicks);
        lastRecordStableTickTime = StableClientTimer.getStableTickTime();
        lastRecordStablePartialTicks = StableClientTimer.getStablePartialTicks();
        client.m_91307_().m_7238_();
    }

    @Nullable
    private static TeleportationUtil.Teleportation tryTeleport(float partialTicks) {
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        assert (player != null);
        Vec3 thisFrameEyePos = ClientTeleportationManager.getPlayerEyePos(partialTicks);
        if (lastPlayerEyePos.m_82557_(thisFrameEyePos) > 1600.0) {
            return null;
        }
        assert (ClientTeleportationManager.client.f_91073_ != null);
        long currentGameTime = ClientTeleportationManager.client.f_91073_.m_46467_();
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos((Entity)player);
        Vec3 thisTickEyePos = McHelper.getEyePos((Entity)player);
        ArrayList teleportationCandidates = new ArrayList();
        IPMcHelper.traverseNearbyPortals(player.m_9236_(), thisFrameEyePos, IPGlobal.maxNormalPortalRadius, portal -> {
            if (!portal.canTeleportEntity((Entity)player)) {
                return;
            }
            if (portal.animation.clientLastFramePortalStateCounter == teleportationCounter - 1L && portal.animation.clientLastFramePortalState != null && portal.animation.lastTickAnimatedState != null && portal.animation.thisTickAnimatedState != null) {
                assert (portal.animation.clientCurrentFramePortalState != null);
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkDynamicTeleportation(portal, portal.animation.clientLastFramePortalState, portal.animation.clientCurrentFramePortalState, lastPlayerEyePos, thisFrameEyePos, portal.animation.lastTickAnimatedState, portal.animation.thisTickAnimatedState, lastTickEyePos, thisTickEyePos, partialTicks);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            } else {
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkStaticTeleportation(portal, lastPlayerEyePos, thisFrameEyePos, lastTickEyePos, thisTickEyePos);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            }
        });
        TeleportationUtil.Teleportation teleportation = teleportationCandidates.stream().min(Comparator.comparingDouble(p -> p.collidingPos().m_82557_(lastPlayerEyePos))).orElse(null);
        if (teleportation != null) {
            Portal portal2 = teleportation.portal();
            Vec3 collidingPos = teleportation.collidingPos();
            client.m_91307_().m_6180_("portal_teleport");
            ClientTeleportationManager.teleportPlayer(teleportation, partialTicks);
            client.m_91307_().m_7238_();
            boolean allowOverlappedTeleport = portal2.respectParallelOrientedPortal();
            double adjustment = allowOverlappedTeleport ? -0.001 : 0.001;
            lastPlayerEyePos = teleportation.teleportationCheckpoint().m_82549_(portal2.getContentDirection().m_82490_(adjustment));
            return teleportation;
        }
        return null;
    }

    public static Vec3 getPlayerEyePos(float partialTick) {
        return ClientTeleportationManager.client.f_91074_.m_20299_(partialTick);
    }

    private static void teleportPlayer(TeleportationUtil.Teleportation teleportation, float partialTicks) {
        Portal portal = teleportation.portal();
        if (tickTimeForTeleportation <= teleportTickTimeLimit) {
            Helper.log("Client player teleportation rejected");
            return;
        }
        lastTeleportGameTime = tickTimeForTeleportation;
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        Validate.isTrue((player != null ? 1 : 0) != 0);
        ResourceKey<Level> toDimension = portal.dimensionTo;
        float tickDelta = RenderStates.getPartialTick();
        Vec3 thisTickEyePos = McHelper.getEyePos((Entity)player);
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos((Entity)player);
        Vec3 newThisTickEyePos = teleportation.newThisTickEyePos();
        Vec3 newLastTickEyePos = teleportation.newLastTickEyePos();
        ClientLevel fromWorld = ClientTeleportationManager.client.f_91073_;
        ResourceKey fromDimension = fromWorld.m_46472_();
        if (fromDimension != toDimension) {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, newThisTickEyePos);
        }
        Vec3 oldRealVelocity = McHelper.getWorldVelocity((Entity)player);
        TransformationManager.managePlayerRotationAndChangeGravity(portal);
        McHelper.setWorldVelocity((Entity)player, oldRealVelocity);
        TeleportationUtil.PortalPointVelocity portalPointVelocity = teleportation.portalPointVelocity();
        TeleportationUtil.transformEntityVelocity(portal, (Entity)player, portalPointVelocity);
        if (player.m_20202_() != null) {
            TeleportationUtil.transformEntityVelocity(portal, player.m_20202_(), portalPointVelocity);
        }
        McHelper.setEyePos((Entity)player, newThisTickEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
        PehkuiInterface.invoker.onClientPlayerTeleported(portal);
        IPMessage.sendToServer(new Teleport((ResourceKey<Level>)fromDimension, lastTickEyePos, portal.m_20148_()));
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((Entity)player, newThisTickEyePos, newLastTickEyePos, RenderStates.getPartialTick());
        McHelper.adjustVehicle((Entity)player);
        RenderStates.updatePreRenderInfo(tickDelta);
        if (teleportation.isDynamic()) {
            LOGGER.info("Client Teleported Dynamically\nportal: {}\ntickTime: {}\nduring ticking: {}\ncounter: {}\neye pos (by frame): {} -> {}\npartial ticks: {}\nnew immediate eye pos: {}\nportal origin/normal: {} {}\nportal dest/content dir: {} {}", new Object[]{portal, tickTimeForTeleportation, isTicking, teleportationCounter, teleportation.lastFrameEyePos(), teleportation.thisFrameEyePos(), Float.valueOf(partialTicks), teleportation.newLastTickEyePos().m_165921_(teleportation.newThisTickEyePos(), (double)tickDelta), portal.getOriginPos(), portal.getNormal(), portal.getDestPos(), portal.getContentDirection()});
        } else {
            LOGGER.info("Client Teleported Statically\nportal: {}\neye pos: {} -> {}", new Object[]{portal, teleportation.lastFrameEyePos(), teleportation.thisFrameEyePos()});
        }
        isTeleportingTick = true;
        isTeleportingFrame = true;
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static boolean isTeleportingFrequently() {
        return tickTimeForTeleportation - lastTeleportGameTime <= 100L || tickTimeForTeleportation <= teleportTickTimeLimit;
    }

    public static void forceTeleportPlayer(ResourceKey<Level> toDimension, Vec3 destination) {
        LOGGER.info("client player force teleported {} {}", toDimension, (Object)destination);
        ClientLevel fromWorld = ClientTeleportationManager.client.f_91073_;
        ResourceKey fromDimension = fromWorld.m_46472_();
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        assert (player != null);
        if (fromDimension != toDimension) {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            Vec3 eyeOffset = McHelper.getEyeOffset((Entity)player);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, destination.m_82549_(eyeOffset));
        }
        player.m_6034_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
        McHelper.adjustVehicle((Entity)player);
        lastPlayerEyePos = null;
        RenderStates.updatePreRenderInfo(RenderStates.getPartialTick());
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static void changePlayerDimension(LocalPlayer player, ClientLevel fromWorld, ClientLevel toWorld, Vec3 newEyePos) {
        Validate.isTrue((!WorldRenderInfo.isRendering() ? 1 : 0) != 0);
        Validate.isTrue((!FrontClipping.isClippingEnabled ? 1 : 0) != 0);
        Validate.isTrue((!PacketRedirectionClient.getIsProcessingRedirectedMessage() ? 1 : 0) != 0);
        Entity vehicle = player.m_20202_();
        player.m_19877_();
        ResourceKey toDimension = toWorld.m_46472_();
        ResourceKey fromDimension = fromWorld.m_46472_();
        ((IEClientPlayNetworkHandler)client.m_91403_()).ip_setWorld(toWorld);
        fromWorld.m_171642_(player.m_19879_(), Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)player).ip_setWorld((Level)toWorld);
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        ((IEEntity)player).ip_unsetRemoved();
        toWorld.m_104630_(player.m_19879_(), (AbstractClientPlayer)player);
        ((IEAbstractClientPlayer)player).ip_setClientLevel(toWorld);
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.m_91087_().f_91063_;
        gameRenderer.setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)toDimension).lightmapTexture);
        ClientTeleportationManager.client.f_91073_ = toWorld;
        ((IEMinecraftClient)client).setWorldRenderer(ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)toDimension));
        toWorld.m_104669_(fromWorld.m_6188_());
        if (ClientTeleportationManager.client.f_91061_ != null) {
            ((IEParticleManager)ClientTeleportationManager.client.f_91061_).ip_setWorld(toWorld);
        }
        client.m_167982_().m_112257_((Level)toWorld);
        if (vehicle != null) {
            Vec3 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (Entity)player);
            Vec3 vehiclePos = player.m_20182_().m_82549_(offset);
            ClientTeleportationManager.moveClientEntityAcrossDimension(vehicle, toWorld, vehiclePos);
            McHelper.setPosAndLastTickPos(vehicle, player.m_20182_().m_82549_(offset), McHelper.lastTickPosOf((Entity)player).m_82549_(offset));
            player.m_7998_(vehicle, true);
        }
        Helper.log(String.format("Client Changed Dimension from %s to %s time: %s age: %s", fromDimension.m_135782_(), toDimension.m_135782_(), tickTimeForTeleportation, player.f_19797_));
        FogRendererContext.onPlayerTeleport((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
        O_O.onPlayerChangeDimensionClient((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
    }

    private static void changePlayerMotionIfCollidingWithPortal() {
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        Portal portal = ((IEEntity)player).ip_getCollidingPortal();
        if (portal != null) {
            if (PortalExtension.get((Portal)portal).motionAffinity > 0.0) {
                ClientTeleportationManager.changeMotion((Entity)player, portal);
            } else if (PortalExtension.get((Portal)portal).motionAffinity < 0.0 && player.m_20184_().m_82553_() > 0.7) {
                ClientTeleportationManager.changeMotion((Entity)player, portal);
            }
        }
    }

    private static void changeMotion(Entity player, Portal portal) {
        Vec3 velocity = player.m_20184_();
        player.m_20256_(velocity.m_82490_(1.0 + PortalExtension.get((Portal)portal).motionAffinity));
    }

    public static void moveClientEntityAcrossDimension(Entity entity, ClientLevel newWorld, Vec3 newPos) {
        ClientLevel oldWorld = (ClientLevel)entity.m_9236_();
        oldWorld.m_171642_(entity.m_19879_(), Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)entity).ip_setWorld((Level)newWorld);
        entity.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        ((IEEntity)entity).ip_unsetRemoved();
        newWorld.m_104627_(entity.m_19879_(), entity);
        Validate.isTrue((!entity.m_213877_() ? 1 : 0) != 0);
    }

    public static void disableTeleportFor(int ticks) {
        teleportTickTimeLimit = tickTimeForTeleportation + (long)ticks;
    }

    private static void adjustPlayerPosition(LocalPlayer player) {
        Function<VoxelShape, VoxelShape> shapeFilter;
        if (player.m_5833_()) {
            return;
        }
        if (player.m_20202_() != null) {
            return;
        }
        AABB playerBoundingBox = player.m_20191_();
        PortalCollisionHandler portalCollisionHandler = ((IEEntity)player).ip_getPortalCollisionHandler();
        List<Object> collidingPortals = portalCollisionHandler == null ? Collections.emptyList() : portalCollisionHandler.getCollidingPortals();
        Direction gravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
        Direction levitationDir = gravityDir.m_122424_();
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset((Entity)player);
        AABB bottomHalfBox = playerBoundingBox.m_82310_(eyeOffset.f_82479_ / 2.0, eyeOffset.f_82480_ / 2.0, eyeOffset.f_82481_ / 2.0);
        AABB collisionUnion = CollisionHelper.getTotalBlockCollisionBox((Entity)player, bottomHalfBox, shapeFilter = c -> {
            VoxelShape curr = c;
            for (Portal collidingPortal : collidingPortals) {
                if ((curr = CollisionHelper.clipVoxelShape(curr, collidingPortal.getOriginPos(), collidingPortal.getNormal())) != null) continue;
                return null;
            }
            return curr;
        });
        if (collisionUnion == null) {
            return;
        }
        Vec3 anchor = player.m_20182_();
        AABB collisionUnionLocal = Helper.transformBox(collisionUnion, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.m_82546_(anchor)));
        AABB playerBoxLocal = Helper.transformBox(playerBoundingBox, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.m_82546_(anchor)));
        double targetLocalY = collisionUnionLocal.f_82292_ + 0.01;
        double originalLocalY = playerBoxLocal.f_82289_;
        double delta = targetLocalY - originalLocalY;
        if (delta <= 0.0) {
            return;
        }
        Vec3 levitationVec = Vec3.m_82528_((Vec3i)levitationDir.m_122436_());
        Vec3 offset = levitationVec.m_82490_(delta);
        int ticks = 5;
        Helper.log("Adjusting Client Player Position");
        int[] counter = new int[]{0};
        IPGlobal.clientTaskList.addTask(() -> {
            Vec3 newEyePos;
            Vec3 eyePos;
            if (player.m_213877_()) {
                return true;
            }
            if (GravityChangerInterface.invoker.getGravityDirection((Entity)player) != gravityDir) {
                return true;
            }
            if (counter[0] >= 5) {
                return true;
            }
            counter[0] = counter[0] + 1;
            double len = player.m_20182_().m_82546_(anchor).m_82526_(levitationVec);
            if (len < -1.0 || len > 2.0) {
                return true;
            }
            double progress = (double)counter[0] / 5.0;
            progress = TransformationManager.mapProgress(progress);
            Vec3 expectedPos = anchor.m_82549_(offset.m_82490_(progress));
            Vec3 newPos = Helper.putCoordinate(player.m_20182_(), levitationDir.m_122434_(), Helper.getCoordinate(expectedPos, levitationDir.m_122434_()));
            Portal currentCollidingPortal = ((IEEntity)player).ip_getCollidingPortal();
            if (currentCollidingPortal != null && currentCollidingPortal.rayTrace(eyePos = McHelper.getEyePos((Entity)player), newEyePos = newPos.m_82549_(McHelper.getEyeOffset((Entity)player))) != null) {
                return true;
            }
            player.m_20343_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            McHelper.updateBoundingBox((Entity)player);
            return false;
        });
    }

    public static class RemoteCallables {
        public static void updateEntityPos(ResourceKey<Level> dim, int entityId, Vec3 pos) {
            ClientLevel world = ClientWorldLoader.getWorld(dim);
            Entity entity = world.m_6815_(entityId);
            if (entity == null) {
                Helper.err("cannot find entity to update position");
                return;
            }
            entity.m_6453_(pos.f_82479_, pos.f_82480_, pos.f_82481_, entity.m_146908_(), entity.m_146909_(), 0, false);
            entity.m_146884_(pos);
        }
    }

    private record TeleportationRec(Portal portal, Vec2d portalLocalXY, Vec3 collisionPos) {
    }
}

